<?php
/**
 * Use Custom color setting in the theme package
 *
 * @package NewsBlogger
*/
function newsblogger_custom_color_css() {
	$link_color = get_theme_mod('link_color','#369ef6');
	list($r, $g, $b) = sscanf($link_color, "#%02x%02x%02x");
	?>
	<style type="text/css">
		body.newsblogger a:hover, body.newsblogger a:focus, body.entry-meta a:hover span, body.entry-meta a:focus span, body dl dd a, body dl dd a:hover, body dl dd a:focus, body ul li a:focus { color: <?php echo esc_attr($link_color); ?>; }
		body.newsblogger button, body.newsblogger input[type="button"], body.newsblogger input[type="submit"] { color: #ffffff; border:1px solid <?php echo esc_attr($link_color); ?>; }
		body.newsblogger button:hover, body button:focus, body.newsblogger input[type="button"]:hover, body.newsblogger input[type="button"]:focus, body.newsblogger input[type="submit"]:hover, body.newsblogger input[type="submit"]:focus { background: <?php echo esc_attr($link_color); ?>; }
		body.newsblogger form.search-form input.search-submit, body.newsblogger input[type="submit"], body button[type="submit"], .newsblogger .spnc-post-list-view-section .spnc-post .spnc-post-overlay .spnc-date a, .newsblogger .pagination a:is(:hover, :focus), .newsblogger .navigation.pagination .nav-links .current, .newsblogger .pagination a.prev:is(:hover, :focus), .newsblogger .pagination a.next:is(:hover, :focus), .newsblogger .spnc-highlights-1 .spnc-highlights-title, .newsblogger .spnc-wrapper.spnc-btn-1 .spnc-sidebar .widget.side-bar-widget .spnc-widget-title, .newsblogger .spnc-wrapper.spnc-btn-1 #spnc_panelSidebar .spnc-sidebar .widget.spnc-side-panel .widget-title, .newsblogger .spnc-bnr-1 .spnc-post .spnc-post-content .spnc-info-link, .newsblogger .spnc-wrapper.spnc-btn-1 .spnc-common-widget-area .spnc-main-wrapper .spnc-main-wrapper-heading, .newsblogger .widget_newscrunch_adv .adv-img-content a, .newsblogger .spnc-wrapper.spnc-btn-1 .spnc-sidebar .widget.widget_block :is(h1,h2,h3,h4,h5,h6), .newsblogger .spnc-wrapper.spnc-btn-1 .spnc-page-section-space .widget .wp-block-heading, .newsblogger .spnc-sidebar .widget .wp-block-tag-cloud a:is(:hover, :focus), .newsblogger .spnc-label-tab.active, .newsblogger .spnc-wrapper.spnc-btn-1 .spnc-sidebar .wp-block-search .wp-block-search__label, .newsblogger .scroll-up a, .newsblogger .footer-sidebar .wp-block-search .wp-block-search__label:after, .newsblogger .footer-sidebar .widget .wp-block-heading:after, body.newsblogger .footer-sidebar .widget .widget-title:after, .newsblogger .spnc-wrapper.spnc-btn-1 .spnc-related-posts .spnc-main-wrapper .spnc-main-wrapper-heading, .newsblogger .spnc-wrapper.spnc-btn-1 .comment-form .spnc-blog-1-heading, .newsblogger .footer-sidebar .widget .wp-block-tag-cloud a:is(:hover, :focus), .newsblogger .spnc-category-page .spnc-blog-cat-wrapper .spnc-first-catpost .spnc-more-link { background-color: <?php echo esc_attr($link_color); ?> ; }
		[data-theme="spnc_dark"] .newsblogger.nchild .header-12 .spnc-custom .spnc-nav > .active > a, [data-theme="spnc_dark"] .newsblogger.nchild .header-12 .spnc-custom .spnc-nav .dropdown.open.active > a, .newsblogger .header-12 .spnc-custom .spnc-nav > li > a:focus, [data-theme="spnc_dark"] .newsblogger.nchild .header-12 .spnc-custom .spnc-nav > li > a:focus, .newsblogger .header-12 .spnc-custom .spnc-nav > li > a:hover, [data-theme="spnc_dark"] .newsblogger.nchild .header-12 .spnc-custom .spnc-nav > li > a:hover, .newsblogger .header-12 .spnc-custom .spnc-nav .open > a, [data-theme="spnc_dark"] .newsblogger.nchild .header-12 .spnc-custom .spnc-nav .open > a, .newsblogger .header-12 .spnc-custom .spnc-nav .open > a:focus, [data-theme="spnc_dark"] .newsblogger.nchild .header-12 .spnc-custom .spnc-nav .open > a:focus, .newsblogger .header-12 .spnc-custom .spnc-nav .open > a:hover, [data-theme="spnc_dark"] .newsblogger.nchild .header-12 .spnc-custom .spnc-nav .open > a:hover, .newsblogger.nchild .header-12 .spnc-custom .spnc-nav > li > a:focus, .newsblogger.nchild .header-12 .spnc-custom .spnc-nav > li > a:hover, .newsblogger.nchild .header-12 .spnc-custom .spnc-nav .open .dropdown-menu > .active > a, .newsblogger.nchild .header-12 .spnc-custom .spnc-nav .open .dropdown-menu > .active > a:is(:hover, :focus) { background-color: transparent; color: <?php echo esc_attr($link_color); ?>; }
		.newsblogger .header-12 .spnc-custom .dropdown-menu { border-top: 1px solid <?php echo esc_attr($link_color); ?>; border-bottom: 1px solid <?php echo esc_attr($link_color); ?>; }
		[data-theme="spnc_dark"] .newsblogger.nchild .spnc-nav > li.parent-menu > a:hover, [data-theme="spnc_dark"] .newsblogger.nchild .spnc-custom .spnc-nav .dropdown.open > a:hover, [data-theme="spnc_dark"] .newsblogger.nchild .header-12 .spnc-nav > li.parent-menu .dropdown-menu a:is(:hover:focus), .newsblogger.nchild .header-12 .spnc-custom .spnc-nav > .active > a, .newsblogger.nchild .header-12 .spnc-custom .spnc-nav > .active > a:hover, .newsblogger.nchild .header-12 .spnc-custom .spnc-nav > .active > a:focus, .newsblogger.nchild .header-12 .spnc-custom .spnc-nav .dropdown-menu li > a:hover, .newsblogger.nchild .header-12 .spnc-date-social .header-date .date:hover, .newsblogger.nchild .header-12 .spnc-date-social .header-date .date:focus, .newsblogger.nchild .header-12 .spnc-trending-widget .spnc-trending-post-title a:hover, .newsblogger.nchild .header-12 .spnc-trending-widget .spnc-trending-title a:hover, [data-theme="spnc_dark"] body.newscrunch.newsblogger #wrapper .header-12.header-sidebar .spnc-custom .spnc-collapse .spnc-nav .dropdown-menu > li.active > a, [data-theme="spnc_dark"] body.newscrunch.newsblogger #wrapper .header-12.header-sidebar .spnc-custom .spnc-collapse .spnc-nav li.active > a, body.newsblogger .spnc-highlights-2.spnc-highlights-1 .spnc-marquee-wrapper .spnc-entry-title a:is(:hover, :focus), body.newsblogger .spnc-highlights-1 .spnc-entry-meta span a:hover, body.newsblogger .spnc-highlights-1 .spnc-entry-meta span a:focus, .newsblogger .spnc-post-list-view-section .spnc-post .spnc-post-content .spnc-entry-meta i, .newsblogger .spnc-post-list-view-section .spnc-post .spnc-post-content .spnc-entry-title a:is(:hover, :focus), .newsblogger .spnc-post-list-view-section .spnc-post .spnc-post-content .spnc-entry-content .spnc-entry-meta a:is(:hover, :focus), .spnc-missed-section .spnc-entry-meta span.spnc-author a:is(:hover, :focus), [data-theme="spnc_dark"] .newsblogger.nchild .widget_newscrunch_list_view_slider .spnc-blog-wrapper .latest-blog-post .spnc-post .spnc-entry-meta:has(.spnc-author, .spnc-cat-links) a:is(:hover, :focus), body.newsblogger .site-info p.copyright-section a, .spnc-single-post .spnc-blog-wrapper .spnc-post .spnc-entry-meta span i, [data-theme="spnc_dark"] .spnc-single-post .spnc-blog-wrapper .spnc-post .spnc-entry-meta span i, .newsblogger .spnc-blog-page .spnc-entry-meta a:is(:hover, :focus), .newsblogger .custom-logo-link-url .site-title a:is(:hover, :focus), .newsblogger .spnc-bnr-1 .spnc-entry-meta a:is(:hover, :focus), .newsblogger .spnc-bnr-1 h3.spnc-entry-title a:is(:hover, :focus), body.newsblogger .widget_newscrunch_featured_post .spnc-post .spnc-entry-meta a:is(:hover, :focus), .newsblogger .widget_newscrunch_featured_post h4.spnc-entry-title a:is(:hover, :focus), .newsblogger .widget_newscrunch_featured_post .spnc-post .spnc-more-link:is(:hover, :focus), .newsblogger .widget_newscrunch_featured_post .spnc-first-post .spnc-post .spnc-post-content span a:is(:hover, :focus), .newsblogger .widget_newscrunch_featured_post .spnc-first-post h4.spnc-entry-title a:is(:hover, :focus), .newsblogger .spnc-blog-1 .spnc-blog-wrapper h4.spnc-entry-title a:is(:hover, :focus), .newsblogger .widget_newscrunch_grid_slider_three_column .spnc-post-grid-slider-three-column .spnc-entry-meta .spnc-date a, .newsblogger .widget_newscrunch_grid_slider_three_column .spnc-post-grid-slider-three-column .spnc-entry-meta .spnc-date a:is(:hover, :focus), .newsblogger .widget_newscrunch_grid_slider_three_column .spnc-post-grid-slider-three-column .spnc-entry-meta a:is(:hover, :focus), .newsblogger .widget_newscrunch_post_grid_two_col .widget-recommended-post li a:is(:hover, :focus), .newsblogger .spnc-blog-1 .spnc-blog-wrapper .spnc-post .spnc-entry-meta a:is(:hover, :focus), .newsblogger .spnc-blog-2 .spnc-blog-wrapper-1 h4.spnc-entry-title a:is(:hover, :focus), .newsblogger .spnc-blog-2 .spnc-blog-wrapper-1 .spnc-post .spnc-entry-meta .spnc-date a:is(:hover, :focus), .newsblogger .spnc-sidebar .spnc-panel ul li a:is(:hover, :focus), .newsblogger .spnc-blog-2 .spnc-blog-wrapper h4.spnc-entry-title a:is(:hover, :focus), .newsblogger .spnc-blog-2 .spnc-blog-wrapper .spnc-post .spnc-entry-meta a:is(:hover, :focus), .newsblogger .spnc-blog-2 .spnc-blog-wrapper .spnc-entry-meta span.spnc-author a:is(:hover, :focus),  body.newsblogger .widget_newscrunch_overlay_slider .spnc-blog1-carousel .spnc-post .spnc-entry-meta a:is(:hover, :focus), .newsblogger .widget_newscrunch_single_column .single-column .spnc-post-content a:is(:hover, :focus), .newsblogger .widget .wp-block-latest-posts li a:is(:hover, :focus), .newsblogger .widget .wp-block-archives li a:is(:hover, :focus), .newsblogger .widget .wp-block-categories li a:is(:hover, :focus), .newsblogger .widget .wp-block-page-list li a:is(:hover, :focus), .newsblogger .widget .wp-block-rss li a:is(:hover, :focus), .newsblogger .widget_meta ul li a:is(:hover, :focus), .newsblogger .widget .wp-block-latest-comments li a:is(:hover, :focus), .newsblogger .spnc-sidebar .widget ul li::before, .newsblogger .spnc-sidebar .widget ol li::before, .newsblogger .widget .wp-block-latest-comments li article footer::before, .newsblogger .spncmc-1 h4.spnc-entry-title a:is(:hover, :focus), .newsblogger .spncmc-1 .spnc-entry-meta .spnc-date a, .newsblogger .site-footer .footer-sidebar .widget_newscrunch_post_grid_two_col .widget-recommended-post li a:is(:hover, :focus), body.newsblogger #wrapper .widget.f-w-c.widget_newscrunch_single_column .spnc-post-content a:is(:hover, :focus), .newsblogger .spnc-single-post .spnc-blog-wrapper .spnc-entry-meta span.spnc-tag-links a:is(:hover, :focus), .newsblogger .spnc-single-post .spnc-blog-wrapper .spnc-entry-meta span.spnc-author a:is(:hover, :focus), .newsblogger .spnc-single-post .spnc-blog-wrapper .spnc-entry-meta span.spnc-date a:is(:hover, :focus), .newsblogger .spnc-single-post .spnc-pagination-single .spnc-post-content a, .newsblogger .spnc-single-post .spnc-pagination-single .spnc-post-content h4.spnc-entry-title a:is(:hover, :focus), .newsblogger .spnc-related-posts .spnc-related-post-wrapper .spnc-post .spnc-post-content .spnc-entry-meta span i, .newsblogger .spnc-related-posts .spnc-related-post-wrapper .spnc-post .spnc-post-content .spnc-entry-meta span a:is(:hover, :focus), .newsblogger .spnc-related-posts .spnc-related-post-wrapper .spnc-post .spnc-entry-title a:is(:hover, :focus), .newsblogger .spnc-blog-page .spnc-entry-meta i, .newsblogger .spnc-blog-page .spnc-footer-meta .spnc-date a:is(:hover, :focus), .newsblogger .site-footer .site-info .footer-nav li a:is(:hover, :focus), [data-theme="spnc_dark"] .newsblogger .spnc_sidebar_panel a:is(:hover, :focus), [data-theme="spnc_dark"] .newsblogger .spnc-blog-page .spnc-entry-meta a:is(:hover, :focus), [data-theme="spnc_dark"] body.newsblogger .spnc-wrapper a.wp-block-latest-comments__comment-author:is(:hover, :focus), [data-theme="spnc_dark"] body.newsblogger .spnc-wrapper a.wp-block-latest-comments__comment-link:is(:hover, :focus), [data-theme="spnc_dark"] .newsblogger .site-footer .widget:has(.wp-block-page-list, .wp-block-categories, .wp-block-archives, .wp-block-latest-posts, .wp-block-rss ) li a:is(:hover, :focus), [data-theme="spnc_dark"] .newsblogger .site-footer .widget_meta ul li a:is(:hover, :focus), [data-theme="spnc_dark"] body.newsblogger .spnc-single-post .spnc-blog-wrapper .spnc-post .spnc-entry-meta .spnc-tag-links a:not(.spnc-post-footer-content .spnc-tag-links a):is(:hover, :focus), [data-theme="spnc_dark"] body.newsblogger .spnc-single-post .spnc-blog-wrapper .spnc-post .spnc-entry-meta .spnc-author a:is(:hover, :focus), [data-theme="spnc_dark"] .newsblogger .spnc-single-post .spnc-blog-wrapper .spnc-post .spnc-entry-meta .single.spnc-date a:is(:hover, :focus), [data-theme="spnc_dark"] .newsblogger .spnc-single-post .spnc-blog-wrapper .spnc-related-posts .spnc-post .spnc-entry-meta a:not(.spnc-entry-meta .spnc-cat-links a):is(:hover, :focus), [data-theme="spnc_dark"] .newsblogger .spnc-single-post .spnc-blog-wrapper .spnc-related-posts .spnc-post .spnc-entry-meta .spnc-date a:not(.spnc-entry-meta .spnc-cat-links a):is(:hover, :focus), .newsblogger .page-breadcrumb > li a:is(:hover, :focus), .newsblogger .spnc-category-page .spnc-grid-catpost .spnc-entry-meta a:is(:hover, :focus), .newsblogger .spnc-category-page .spnc-blog-cat-wrapper .spnc-first-catpost .spnc-entry-meta a:is(:hover, :focus), .newsblogger .spnc-category-page .spnc-blog-cat-wrapper .spnc-first-catpost .spnc-entry-title a:is(:hover, :focus), .newsblogger .spnc-category-page .spnc-grid-catpost .spnc-entry-meta i, [data-theme="spnc_dark"] .newsblogger .spnc-category-page .spnc-grid-catpost .spnc-entry-meta a:hover, [data-theme="spnc_dark"] .newsblogger .spnc-category-page .spnc-grid-catpost .spnc-footer-meta .spnc-date a:hover, [data-theme="spnc_dark"] body.newscrunch.newsblogger .spnc-custom .spnc-nav .menu-item-has-children .open.active > a  { 
				color: <?php echo esc_attr($link_color); ?>; 
		}
		.newsblogger.nchild .header-12.header-sidebar .spnc-custom .spnc-header-logo .custom-date-social-icons li a:hover, .newsblogger.nchild .header-12 .spnc-custom .spnc-dark-icon:hover { color: #fff; background: <?php echo esc_attr($link_color); ?>; }
		.newsblogger.nchild .header-12 .spnc-custom .spnc-nav .open > a:hover { text-shadow: unset; }
		.newsblogger.nchild .header-12 .spnc-header-btn:hover { background-color: <?php echo esc_attr($link_color); ?>; color: #fff; }
		.newsblogger.nchild .header-12 .spnc-custom .spnc-widget-toggle > a.spnc-toggle-icon:is(:hover,:focus) { text-shadow: unset; color: <?php echo esc_attr($link_color); ?>; }
		@media (max-width: 1100px) {
			body.newsblogger .header-12.header-sidebar .spnc-custom .spnc-nav > .active.menu-item > a, 
			body.newsblogger .header-12 .spnc-custom .spnc-nav > .active > a:is(:hover, :focus) { background-color: transparent; color: <?php echo esc_attr($link_color); ?>; }
			.newsblogger .header-12 .spnc-custom .spnc-nav .dropdown-menu li.active > a, 
			[data-theme="spnc_dark"] body.newscrunch.newsblogger #wrapper .header-12.header-sidebar .spnc-custom .spnc-collapse .spnc-nav .dropdown-menu > li.active > a, 
			[data-theme="spnc_dark"] body.newscrunch.newsblogger #wrapper .header-12.header-sidebar .spnc-custom .spnc-collapse .spnc-nav li.active > a  { color: <?php echo esc_attr($link_color); ?>; }
		}
		.newsblogger .spnc-post-list-view-section .spnc-post .spnc-post-content .spnc-entry-content figure, .newsblogger .widget_newscrunch_list_view_slider .spnc-blog-wrapper .spnc-entry-meta img { border: 1px solid <?php echo esc_attr($link_color); ?> }
		.newsblogger .spnc-post-list-view-section .spnc-post .spnc-post-content .spnc-more-link:is(:hover, :focus){	background-color: <?php echo esc_attr($link_color); ?>; border: 1px solid <?php echo esc_attr($link_color); ?>; }
		.newsblogger .pagination a.prev:is(:hover, :focus), .newsblogger .pagination a.next:is(:hover, :focus), .newsblogger .pagination .nav-links .current:is(:hover, :focus) { border: none; }
		.newsblogger .pagination a:is(:hover, :focus), .newsblogger .widget_newscrunch_adv .adv-img-content a:is(:hover, :focus), .newsblogger .scroll-up a:is(:hover,:active) { color: #fff; }
		[data-theme="spnc_dark"] .newsblogger.nchild .spnc-single-post .spnc-blog-wrapper .spnc-post .spnc-post-footer-content .spnc-entry-meta .spnc-tag-links a:is(:hover, :focus), .newsblogger .spnc_sidebar_panel::-webkit-scrollbar-thumb, .newsblogger .widget_newscrunch_list_view_slider .spnc-blog-wrapper .spnc-entry-meta::before, .newsblogger .spnc-single-post .comment-form form input[type="submit"] { background: <?php echo esc_attr($link_color); ?>; }
		.newsblogger .spnc-blog-page .pagination a.current, .newsblogger .spnc-blog-page .spnc-entry-content .spnc-more-link:is(:hover, :focus) { color: #fff; background-color: <?php echo esc_attr($link_color); ?>; border: 1px solid <?php echo esc_attr($link_color); ?>; }
		body.newsblogger .spnc-cat-first-post .spnc-post .spnc-post-content .spnc-entry-title a:is(:hover, :focus), body.newsblogger .spnc-cat-first-post .spnc-post .spnc-post-content .spnc-footer-meta .spnc-entry-meta span a:is(:hover, :focus) { color: <?php echo esc_attr($link_color); ?>; }
		body.newsblogger .spnc-cat-first-post .spnc-post .spnc-post-content .spnc-more-link { background-color: <?php echo esc_attr($link_color); ?>; }
		.newsblogger .custom-social-icons li > a:is(:hover, :focus), body.newsblogger .spnc-category-page .spnc-grid-catpost .spnc-footer-meta .spnc-more-link:is(:hover, :focus) { background-color: <?php echo esc_attr($link_color); ?>; color: #ffffff; border-color: <?php echo esc_attr($link_color); ?>; }
		.newsblogger #spnc-marquee-right:is(:hover, :focus), .newsblogger #spnc-marquee-left:is(:hover, :focus) {  background-color: <?php echo esc_attr($link_color); ?>;  box-shadow: 0 0 1px 1px <?php echo esc_attr($link_color); ?>; }
		.newsblogger .spnc-wrapper.spnc-btn-1 .spnc-widget-heading, .newsblogger .spnc-wrapper.spnc-btn-1 .spnc-common-widget-area .spnc-main-wrapper, .newsblogger .spnc-wrapper.spnc-btn-1 .spnc-tabs, .newsblogger .spnc-wrapper.spnc-btn-1 .spnc-sidebar .wp-block-search .wp-block-search__label::after, .newsblogger .spnc-wrapper.spnc-btn-1 .spnc-sidebar .widget.widget_block :is(h1,h2,h3,h4,h5,h6)::after, .newsblogger .spnc-wrapper.spnc-btn-1 .spnc-page-section-space .widget .wp-block-heading::after, .newsblogger .spnc-wrapper.spnc-btn-1 .spnc-related-posts .spnc-main-wrapper, .newsblogger .spnc-wrapper.spnc-btn-1 .comment-form .spnc-blog-1-wrapper {  border-bottom: 1px solid <?php echo esc_attr($link_color); ?>;
		}
		body.newscrunch.newsblogger .owl-carousel .owl-nav .owl-prev:is(:hover, :focus), body.newscrunch.newsblogger .owl-carousel .owl-nav .owl-next:is(:hover, :focus) { color: #ffffff; background-color: <?php echo esc_attr($link_color); ?>; box-shadow: 0 0 1px 1px <?php echo esc_attr($link_color); ?>; }
		body.newscrunch.newsblogger #page .widget_newscrunch_featured_post .spnc-cat-links a:is(:hover, :focus), .newsblogger .widget_newscrunch_list_view_slider .spnc-blog-wrapper .spnc-post .spnc-entry-meta .spnc-date a { color: #fff; }
		.newsblogger input[type="search"]:is(:hover, :focus), .newsblogger .spnc-single-post .comment-form form input[type="submit"]:is(:hover,:focus), .newsblogger .spnc-single-post .comment-form form textarea:is(:hover, :focus), .newsblogger .spnc-single-post .comment-form form input[type="text"]:is(:hover, :focus), .newsblogger .spnc-single-post .comment-form form input[type="email"]:is(:hover, :focus) { border: 1px solid <?php echo esc_attr($link_color); ?>; }
		.newsblogger .site-footer { border-top: 3px solid <?php echo esc_attr($link_color); ?>; }
		.newsblogger .spnc-single-post .spnc-blog-wrapper .spnc-post .spnc-post-footer-content .spnc-entry-meta a:is(:hover, :focus) { color: #ffffff; background: <?php echo esc_attr($link_color); ?>; }
		.newsblogger .spnc-single-post .comment-form form input[type="submit"]:is(:hover, :focus) { background: #fff; }
		body.newsblogger .widget_newscrunch_featured_post .spnc-first-post .spnc-entry-meta i, body.newsblogger .widget_newscrunch_featured_post .spnc-entry-meta i, body.newsblogger .widget_newscrunch_post_grid_two_col .widget-recommended-post li span i, body.newsblogger .widget_newscrunch_list_view_slider .spnc-blog-wrapper .spnc-entry-meta i, body.newsblogger .widget_newscrunch_post_tabs .spnc-panel .date i, body.newsblogger .widget_newscrunch_grid_slider_two_column .spnc-filter .spnc-entry-meta i, body.newsblogger .spnc-blog-wrapper-1 .spnc-post .spnc-entry-meta .plgv.spnc-date i, body.newsblogger .widget_newscrunch_overlay_slider .spnc-blog1-carousel .spnc-entry-meta i [data-theme="spnc_dark"] body.newsblogger .spnc-sidebar .widget_categories .wp-block-categories-list .cat-item:before, [data-theme="spnc_dark"] body.newsblogger .spnc-sidebar .widget_categories .wp-block-categories-list .cat-item a:is(:hover, :focus) { color: <?php echo esc_attr($link_color); ?>; }
		[data-theme="spnc_dark"] body.newsblogger .spnc-sidebar .widget_categories .wp-block-categories-list .cat-item a { color:#fff; }
		.newsblogger .header-1 .head-contact-info i,.newsblogger .spnc-custom .spnc-nav > li > a:is(:hover, :focus), .newsblogger .spnc-custom .spnc-nav .open > a, .newsblogger .spnc-custom .spnc-nav .open > a:is(:hover, :focus), .newsblogger .spnc-custom .spnc-nav .open .dropdown-menu > .active > a, .newsblogger .spnc-custom .spnc-nav .open .dropdown-menu > .active > a:is(:hover, :focus), body.newscrunch.newsblogger .spnc-custom .spnc-nav li > a.search-icon:is(:hover, :focus), body.newscrunch.newsblogger .spnc-custom .spnc-dark-icon:is(:hover, :focus), .newsblogger .spnc-widget-toggle > a.spnc-toggle-icon:is(:hover, :focus), body.newsblogger .header-2 .spnc-custom .spnc-nav > .active > a,  body.newsblogger .header-2 .spnc-custom .spnc-nav > .active > a:is(:hover, :focus), [data-theme="spnc_light"] body.newscrunch.newsblogger .header-2 .spnc-custom .spnc-nav li > a.search-icon:is(:hover, :focus) { color: <?php echo esc_attr($link_color); ?>; }
		.newsblogger .header-1 .spnc-custom .spnc-navbar, .newsblogger .header-2 .spnc-topbar, .newsblogger .header-2 .spnc-custom .spnc-nav li a:hover:before, .newsblogger .header-2 .spnc-custom .spnc-nav li a:hover:after, .newsblogger .header-2 .spnc-custom .spnc-nav li.active > a:before, .newsblogger .header-2 .spnc-custom .spnc-nav li.active > a:after { background-color: <?php echo esc_attr($link_color); ?>; }
		.newsblogger .spnc-custom .spnc-nav > .active > a, [data-theme="spnc_dark"] .newsblogger .spnc-custom .spnc-nav > .active > a, .newsblogger .spnc-custom .spnc-nav > .active > a:is(:hover, :focus), .newsblogger .header-2 .spnc-widget-toggle > a.spnc-toggle-icon { color: #fff; background-color: <?php echo esc_attr($link_color); ?>; }
		.newsblogger .spnc-custom .dropdown-menu { border-top: 2px solid <?php echo esc_attr($link_color); ?>; border-bottom: 2px solid <?php echo esc_attr($link_color); ?>; }
		body.newsblogger .header-sidebar.header-2 .widget .custom-social-icons li > a:is(:hover,:focus) {
		    color: #fff; border: unset;  background-color: rgba(0, 0, 0, 0.06); }
	   	[data-theme="spnc_dark"] body.newsblogger .header-2 .spnc-custom .spnc-nav > .active > a { color: <?php echo esc_attr($link_color); ?>; background-color:transparent; }
	   [data-theme="spnc_dark"] .newsblogger.nchild .header-1 .spnc-nav > li.parent-menu.active > a:hover { color:#fff; }
	   .newsblogger .pagination a.current{background: <?php echo esc_attr($link_color); ?>; color: #fff;}
	   .newsblogger .spnc-author-box.spnc-author-box-two .spnc-author figure {
		    border-color:  <?php echo esc_attr( "rgba(" . $r . ", " . $g . ", " . $b . ", 0.3)" ) ?>; 
		}
		.newsblogger .spnc-author-box .spnc-author a:is(:hover, :focus), [data-theme="spnc_dark"] .newsblogger .spnc-author-box .spnc-author a:is(:hover, :focus){
		  color:  <?php echo esc_attr($link_color); ?>;
		}
		.newsblogger .spnc-author-box-two .spnc-author .spnc-author-bio,
		.newsblogger .spnc-author-box-one .spnc-author .spnc-author-bio,
		.newsblogger .spnc-author-box  .spnc-author-posts-link{
		    color:  <?php echo esc_attr($link_color); ?>;
		}
		.newsblogger .sticky-post-icon, .newsblogger .spnc-post.format-quote .spnc-quote-wrap, .newsblogger .spnc-post .spnc-post-btn {
		    background-color: <?php echo esc_attr($link_color); ?>;
		}
		.newsblogger .header-13 .spnc-custom .spnc-nav > .active > a,
    	.newsblogger .header-13 .spnc-custom .spnc-nav > .active > a:hover,
    	.newsblogger .header-13 .spnc-custom .spnc-nav > .active > a:focus{
        		color: <?php echo esc_attr($link_color); ?>;
        		background-color: transparent;
    	}
	</style>
<?php }